<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformSection type.
 *
 * @group graphql_webform
 */
class SectionTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the section element.
   */
  public function testSectionElement(): void {
    $query = $this->getQueryFromFile('section.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'elements' => [
          22 => [
            '__typename' => 'WebformElementWebformSection',
            'titleTag' => 'h2',
            'metadata' => [
              'title' => 'Numeric fields section',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
