<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementTextArea type.
 *
 * @group graphql_webform
 */
class TextAreaTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the text area.
   */
  public function testTextArea(): void {
    $query = $this->getQueryFromFile('textarea.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          4 => [
            '__typename' => 'WebformElementTextarea',
            'metadata' => [
              'key' => 'textarea',
              'type' => 'textarea',
              'title' => 'Textarea',
              'description' => 'Tell us a bit more about yourself.',
              'required' => FALSE,
              'requiredError' => NULL,
              'defaultValue' => NULL,
            ],
            'readonly' => FALSE,
            'size' => 100,
            'minlength' => 20,
            'maxlength' => 200,
            'placeholder' => 'Enter your life story here.',
            'pattern' => [
              'rule' => '^A long time ago .*',
              'message' => 'Please start your life story with "A long time ago"',
              '__typename' => 'WebformElementValidationPattern',
            ],
            'rows' => 5,
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
