<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementTextfield type.
 *
 * @group graphql_webform
 */
class TextFieldTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the text fields.
   */
  public function testTextFields(): void {
    $query = $this->getQueryFromFile('textfield.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          0 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => 'required_text_field',
              'type' => 'textfield',
              'title' => 'Required text field',
              'description' => 'The description of the required text field.',
              'required' => TRUE,
              'requiredError' => 'This field is required because it is important.',
              'helpDisplay' => 'TITLE_AFTER',
              'titleDisplay' => 'BEFORE',
              'descriptionDisplay' => 'AFTER',
              'fieldPrefix' => 'prefix',
              'fieldSuffix' => 'suffix',
              'help' => 'help text',
              'helpTitle' => 'Help me',
              'more' => 'more text',
              'moreTitle' => 'more title',
              'disabled' => FALSE,
              'defaultValue' => '',
              'states' => [
                'visible' => NULL,
                'required' => NULL,
              ],
            ],
            'readonly' => FALSE,
            'size' => 10,
            'minlength' => 2,
            'maxlength' => 12,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '.*',
              'message' => 'pattern mess',
            ],
            'inputMask' => "'casing': 'lower'",
          ],
          1 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => 'optional_text_field',
              'type' => 'textfield',
              'title' => 'Optional text field',
              'description' => '',
              'required' => FALSE,
              'requiredError' => '',
              'helpDisplay' => 'DEFAULT',
              'titleDisplay' => 'DEFAULT',
              // For some reason descriptionDisplay is AFTER if it's set to
              // default.
              'descriptionDisplay' => 'AFTER',
              'disabled' => FALSE,
              'fieldPrefix' => '',
              'fieldSuffix' => '',
              'help' => '',
              'helpTitle' => '',
              'more' => '',
              'moreTitle' => '',
              'defaultValue' => '["Default text"]',
              'states' => [
                'visible' => [
                  'conditions' => [
                    [
                      'field' => 'required_text_field',
                      'fieldValue' => '1',
                      'value' => '1',
                      'trigger' => 'FILLED',
                    ],
                    [
                      'field' => 'checkbox2',
                      'fieldValue' => '1',
                      'value' => '1',
                      'trigger' => 'CHECKED',
                    ],
                  ],
                  'logic' => 'OR',
                ],
                'required' => [
                  'logic' => 'AND',
                  'conditions' => [
                    [
                      'field' => 'textarea',
                      'fieldValue' => '1',
                      'value' => '1',
                      'trigger' => 'FILLED',
                    ],
                  ],
                ],
              ],
            ],
            'readonly' => FALSE,
            'size' => 60,
            'minlength' => NULL,
            'maxlength' => 255,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '',
              'message' => '',
            ],
            'inputMask' => '',
          ],
          13 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => '2_years',
              'type' => 'textfield',
              'title' => 'Minimum 2 years, maximum 6',
              'description' => '',
              'required' => FALSE,
              'requiredError' => '',
              'helpDisplay' => 'DEFAULT',
              'titleDisplay' => 'DEFAULT',
              'descriptionDisplay' => 'AFTER',
              'disabled' => FALSE,
              'fieldPrefix' => '',
              'fieldSuffix' => '',
              'help' => '',
              'helpTitle' => '',
              'more' => '',
              'moreTitle' => '',
              'defaultValue' => '["2000","2001"]',
              'states' => [
                'visible' => NULL,
                'required' => NULL,
              ],
            ],
            'readonly' => FALSE,
            'size' => 60,
            'minlength' => NULL,
            'maxlength' => 255,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '\d{4}',
              'message' => 'Please enter a year between 1000 and 9999.',
            ],
            'inputMask' => '',
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
