<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Unit\Plugin\GraphQL\DataProducer;

use Drupal\Tests\UnitTestCase;
use Drupal\graphql_webform\Plugin\GraphQL\DataProducer\WebformSubmit;

/**
 * @coversDefaultClass \Drupal\graphql_webform\Plugin\GraphQL\DataProducer\WebformSubmit
 * @group graphql_webform
 */
class WebformSubmitTest extends UnitTestCase {

  /**
   * @covers ::unflattenElementKeys
   */
  public function testUnflattenValues() {
    // We are testing a protected method. Use reflection to make it accessible.
    $dataProducer = $this->getMockBuilder(WebformSubmit::class)
      ->disableOriginalConstructor()
      ->getMock();
    $reflection = new \ReflectionClass($dataProducer);
    $method = $reflection->getMethod('unflattenElementKeys');
    $method->setAccessible(TRUE);

    $flattenedArray = [
      'required_text_field' => 'A value.',
      'custom_composite_container[items][0][first_name]' => 'Jane',
      'custom_composite_container[items][0][last_name]' => 'Doe',
    ];
    $expectedArray = [
      'required_text_field' => 'A value.',
      'custom_composite_container' => [
        'items' => [
          0 => [
            'first_name' => 'Jane',
            'last_name' => 'Doe',
          ],
        ],
      ],
    ];
    $result = $method->invokeArgs($dataProducer, [$flattenedArray]);
    $this->assertEquals($expectedArray, $result);
  }

}
