# Group Computed Field

Group Computed Field provides a computed field on entities that can be related to Groups in the [Group](https://www.drupal.org/project/group) module.

The main purpose for this is to allow for entities to be related to and filtered by their groups easily in indexes through Search API.

## Installation with Composer

To add Group Computed Field to your site, run the following command with composer:

```bash
composer require drupal/group_computed_field --prefer-dist
```

## Development

### Installation

1. run `composer install`
2. run `npm install`
3. run `npm run prepare`

Alternatively, you can run `npm run init` which is just a shortcut for the above commands.

### Committing

This project uses the conventional commit standard, which means your commits should follow a basic template of:

    <type>[optional scope]: <description>

    [optional body]

    [optional footer(s)]

For more detailed information about available types, scopes, breaking changes, etc. please see the [official documentation](https://www.conventionalcommits.org/en/v1.0.0/).

This project also provides a command to assist you in formatting commit messages using [commitizen](https://commitizen.github.io/cz-cli/):

```bash
npm run commit
```

### Versioning

This project uses Semantic Versioning 2.0.0 to keep track of releases.

    Given a version number MAJOR.MINOR.PATCH, increment the:

    1. MAJOR version when you make incompatible API changes,
    2. MINOR version when you add functionality in a backward compatible manner, and
    3. PATCH version when you make backwards compatible bug fixes.

    Additional labels for pre-release and build metadata are available as extensions to the MAJOR.MINOR.PATCH format.

For more detailed information about SemVer, please see the [official documentation](https://semver.org/).

When making a release, you should use the provided command:

```bash
npm run release
```

This command uses [standard-version](https://github.com/conventional-changelog/standard-version) to parse through your commits, decide what kind of release will be created, and automatically generates a CHANGELOG.md file for your project. These changes are then commited using the message `chore(release): <version number>`.

Once that is done, you can simply run `git push --follow-tags origin` to have your release pushed up to the repository.

### Running code checks

This project provides a few different kinds of code checks.

```bash
npm run lint
npm run lint:php
```

Runs PHPCS using the Drupal/DrupalPractice standards.

### Fixing Code Violations

This project provides commands to run an automated fix for code check failures.

```bash
npm run lint:fix
npm run lint:php:fix
```

### Cleaning the directory

```bash
npm run clean
```

Removes directories generated by npm/composer.
