<?php

declare(strict_types=1);

namespace Drupal\Tests\group_domain\Functional;

use Drupal\Core\Url;
use Drupal\Tests\group\Functional\GroupBrowserTestBase;

/**
 * Test group_domain functionality.
 *
 * @group group_domain
 */
final class GroupDomainTest extends GroupBrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'group_domain',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->setUpAccount();
  }

  /**
   * Test module configuration.
   */
  public function testConfiguration(): void {
    $this->createGroupType();
    $this->drupalGet(Url::fromRoute('group_domain.settings'));
    $this->assertSession()->elementExists('xpath', '//h1[text() = "Group Domain"]');
    $this->submitForm([
      'main_domain' => 'www.example.com',
    ], 'Save');
    $this->assertSession()->pageTextContains('The configuration options have been saved.');
  }

  /**
   * {@inheritdoc}
   */
  protected function getGlobalPermissions(): array {
    return array_merge(parent::getGlobalPermissions(), ['administer group']);
  }

}
