<?php

namespace Drupal\group_inline_entity_form\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Form\FormStateInterface;
use Drupal\group_inline_entity_form\WidgetSubmit;

/**
 * Hook implementations used to alter and enhance forms.
 */
class FormHooks {

  use StringTranslationTrait;

  public function __construct() {}

  /**
   * Implements hook_form_alter().
   *
   * Attach our custom IEF handlers only if the current form has an IEF widget.
   */
  #[Hook('form_alter')]
  public function formAlter(array &$form, FormStateInterface $form_state, $form_id): void {
    $widget_state = $form_state->get('inline_entity_form');
    if (!is_null($widget_state)) {
      WidgetSubmit::attach($form, $form_state);
    }
  }

}
