<?php

namespace Drupal\group_jsonapi_create_access\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Drupal\jsonapi\Routing\Routes;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[RoutingEvents::ALTER] = 'onAlterRoutes';
    return $events;
  }

  /**
   * {@inheritdoc}
   */
  public function alterRoutes(RouteCollection $collection) {
    foreach ($collection as $route_name => $route) {
      // Check if this is a JSON:API POST route for group_relationship.
      $defaults = $route->getDefaults();
      /** @var string|null $resource_type_name */
      $resource_type_name = Routes::getResourceTypeNameFromParameters($defaults);
      if ($resource_type_name && strpos($resource_type_name, 'group_relationship--') === 0) {
        if (in_array('POST', $route->getMethods())) {
          if ($route->hasRequirement('_entity_create_access')) {
            $requirement = $route->getRequirement('_entity_create_access');
            if (strpos($requirement, 'group_relationship:') === 0) {
              // Replace _entity_create_access with our custom access check.
              $requirements = $route->getRequirements();
              unset($requirements['_entity_create_access']);
              $requirements['_group_jsonapi_create_access'] = $requirement;
              $route->setRequirements($requirements);
            }
          }
        }
      }
    }
  }

}
