# Group linked entity

## Introduction

The idea behind this module is to have a content entity (a node most likely) bound to a group.
The content entity holds all the editorial content that you may want to have and group handles the complex access rules that your project needs.
You can now benefit from the countless possibilities and additions that these two modules offer.

### Some assumptions

- Links are "one to one" : meaning a group is linked to only one content entity.
- For now only nodes and taxonomy terms are supported (i cannot think of another use case, additions are welcome though)

## Configuration

On your group type form, define a content type to be used for the linking entity :
![Screenshot of the group_linked_entity module configuration form.](https://www.drupal.org/files/group_linked_entity-config-screenshot.png "group_linked_entity screenshot")

## Under the hood

- For each created group, a content entity will be created and attached to that group.
- When a group is deleted, its corresponding entity is deleted.
- Links are 1 to 1, meaning a group is linked to only one content entity
- An entity is linked to only one group.
- A boolean field is added to the group_relationship between the group and the entity.
- This field, when set, indicates that the relation is the link.
- A helper service containing various useful methods is included.
- On the group entity, an entity reference field (computed) that links to the content entity is added.
- On the content entity, an entity reference field (computed) that links to the group is added.
- Those two fields are regular computed fields so they are discoverable by token and search_api for example

## Requirements

The only requirements are :

- Group (v3)
- Node or Taxonomy

## Maintainers

Current maintainers for Drupal 10 / 11:

- Adel Ben Yacoub (by-adel) - <https://www.drupal.org/u/by-adel>
