<?php

namespace Drupal\group_linked_entity\Field;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * Item list for the linked_entity computed entity reference field.
 */
class LinkedEntity extends EntityReferenceFieldItemList {

  use ComputedItemListTrait;

  /**
   * Compute the values.
   */
  protected function computeValue() {
    /** @var  \Drupal\Core\Entity\ContentEntityBase $group */
    $group = $this->getEntity();
    if ($entity = \Drupal::service('group_linked_entity.helper')->getLinkedEntity($group)) {
      $this->list[] = $this->createItem(0, $entity->id());
    }
  }

}
