<?php

namespace Drupal\group_linked_entity\Field;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * Item list for the linked_group computed entity reference field.
 */
class LinkedGroup extends EntityReferenceFieldItemList {

  use ComputedItemListTrait;

  /**
   * Compute the values.
   */
  protected function computeValue() {
    /** @var  \Drupal\Core\Entity\ContentEntityBase $group */
    $entity = $this->getEntity();
    if ($group = \Drupal::service('group_linked_entity.helper')->getLinkingGroup($entity)) {
      $this->list[] = $this->createItem(0, $group->id());
    }
  }

}
