<?php

declare(strict_types=1);

namespace Drupal\group_linked_entity\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Provides a constraint that prevents linking with multiple entities.
 */
#[Constraint(
  id: 'UniqueLinkingWithEntity',
  label: new TranslatableMarkup('Linking with a single entity.', options: ['context' => 'Validation']),
  type: 'entity:group_relationship'
)]
final class UniqueLinkingWithEntityConstraint extends SymfonyConstraint {

  /**
   * Message error for the UniqueLinkingWithEntity constraint.
   *
   * @var string
   */
  public string $message = 'This group is already linked to an entity.';

}
