<?php

declare(strict_types=1);

namespace Drupal\group_linked_entity\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Drupal\group\Entity\GroupRelationshipInterface;

/**
 * Validates the Linking with a single entity constraint.
 */
final class UniqueLinkingWithEntityConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $group_relationship, Constraint $constraint): void {
    if (!$group_relationship instanceof GroupRelationshipInterface) {
      throw new \InvalidArgumentException(
        sprintf('The validated value must be instance of \Drupal\group\Entity\GroupRelationshipInterface, %s was given.', get_debug_type($group_relationship))
      );
    }

    assert($group_relationship instanceof GroupRelationshipInterface);

    if (!$group_relationship->hasField('group_entity_link')) {
      return;
    }

    // If this relation in not a link, do nothing.
    if ($group_relationship->group_entity_link->isEmpty || !(bool) $group_relationship->group_entity_link->getString()) {
      return;
    }

    // If this is a second link register a violation.
    $group = $group_relationship->getGroup();

    if ($group->hasField('linked_entity') && !$group->get('linked_entity')->isEmpty()) {
      $this->context->addViolation($constraint->message);
    }

  }

}
