<?php

declare(strict_types=1);

namespace Drupal\group_linked_entity\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Provides a constraint that prevents linking with multiple groups.
 */
#[Constraint(
  id: 'UniqueLinkingWithGroup',
  label: new TranslatableMarkup('Linking with a single group.', options: ['context' => 'Validation'])
)]
final class UniqueLinkingWithGroupConstraint extends SymfonyConstraint {

  /**
   * Message error for the UniqueLinkingWithGroup constraint.
   *
   * @var string
   */
  public string $message = 'This entity is already linked to an other group.';

}
