<?php

declare(strict_types=1);

namespace Drupal\group_linked_entity\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\group\Entity\GroupRelationshipInterface;

/**
 * Validates the Linking with a single group constraint.
 */
final class UniqueLinkingWithGroupConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $group_relationship, Constraint $constraint): void {
    if (!$group_relationship instanceof GroupRelationshipInterface) {
      throw new \InvalidArgumentException(
        sprintf('The validated value must be instance of \Drupal\group\Entity\GroupRelationshipInterface, %s was given.', get_debug_type($group_relationship))
      );
    }

    assert($group_relationship instanceof GroupRelationshipInterface);

    // If this relation in not a link, do nothing.
    if (!$group_relationship->hasField('group_entity_link')) {
      return;
    }
    if ($group_relationship->group_entity_link->isEmpty || !(bool) $group_relationship->group_entity_link->getString()) {
      return;
    }
    $entity = $group_relationship->getEntity();
    assert($entity instanceof ContentEntityInterface);

    if ($entity->hasField('linked_group') && !$entity->get('linked_group')->isEmpty()) {
      $this->context->addViolation($constraint->message);
    }

  }

}
