<?php

declare(strict_types=1);

namespace Drupal\group_media_bulk_upload\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * File extension dimensions constraint.
 */
#[Constraint(
  id: 'GroupMediaBulkUploadFileImageDimensions',
  label: new TranslatableMarkup('File Image Dimensions', [], ['context' => 'Validation']),
  type: 'file'
)]
class FileImageDimensionsConstraint extends SymfonyConstraint {

  /**
   * The minimum dimensions.
   *
   * @var string|int
   */
  public string | int $minDimensions = 0;

  /**
   * The maximum dimensions.
   *
   * @var string|int
   */
  public string | int $maxDimensions = 0;

  /**
   * The image too small message.
   *
   * @var string
   */
  public string $messageImageTooSmall = 'The image is too small. The minimum dimensions are %dimensions pixels and the image size is %widthx%height pixels.';

  /**
   * The image too large message.
   *
   * @var string
   */
  public string $messageImageTooLarge = 'The image is too large. The maximum dimensions are %dimensions pixels and the image size is %widthx%height pixels.';

}
