<?php

declare(strict_types=1);

namespace Drupal\group_media_bulk_upload\Controller;

use Drupal\Core\Routing\LocalRedirectResponse;
use Drupal\file\FileInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\group_media_bulk_upload\UploadManager;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Returns responses for Group Media Bulk Upload routes.
 */
class GroupMediaBulkUploadController extends ControllerBase {

  /**
   * Constructs a GroupMediaBulkUploadController.
   *
   * @param \Drupal\group_media_bulk_upload\UploadManager $uploadManager
   *   The upload manager.
   */
  public function __construct(protected readonly UploadManager $uploadManager) {
    // No op.
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get(UploadManager::class),
    );
  }

  /**
   * Builds the response.
   *
   * @param \Drupal\file\FileInterface $file
   *   The file to be canceled.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   The redirect back to the upload process.
   */
  public function cancelFile(FileInterface $file): RedirectResponse {
    $redirect = $this->uploadManager->getNextBulkUploadRedirect();
    $this->uploadManager->setFileStatus((int) $file->id(), UploadManager::STATUS_CANCELLED);
    return new LocalRedirectResponse($redirect->toString());
  }

}
