<?php

declare(strict_types=1);

namespace Drupal\group_media_bulk_upload\Plugin\views\area;

use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Plugin\Context\ContextRepositoryInterface;
use Drupal\group\Entity\GroupInterface;
use Drupal\group_media_bulk_upload\Form\GroupMediaBulkUploadForm;
use Drupal\views\Attribute\ViewsArea;
use Drupal\views\Plugin\views\area\AreaPluginBase;

/**
 * Bulk upload in Views area.
 */
#[ViewsArea("group_media_bulk_upload")]
class GroupBulkUploadArea extends AreaPluginBase {

  /**
   * Constructs a GroupBulkUploadArea.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Form\FormBuilderInterface $formBuilder
   *   The form builder.
   * @param \Drupal\Core\Plugin\Context\ContextRepositoryInterface $contextRepository
   *   The context repository.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly FormBuilderInterface $formBuilder,
    protected readonly ContextRepositoryInterface $contextRepository,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create($container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('form_builder'),
      $container->get('context.repository'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function render($empty = FALSE): array {
    $build = [];

    $contexts = $this->contextRepository->getRuntimeContexts(['@group.group_route_context:group']);
    if (!$group = $contexts['@group.group_route_context:group']->getContextData()->getValue()) {
      return $build;
    }

    assert($group instanceof GroupInterface);
    $build['form'] = $this->formBuilder->getForm(GroupMediaBulkUploadForm::class, $group);

    return $build;
  }

}
