<?php

declare(strict_types=1);

namespace Drupal\group_media_bulk_upload\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\group_media_bulk_upload\GroupMediaUploadAccess;

/**
 * Checks user has access to create group media.
 */
class GroupMediaBulkUploadAccess implements AccessInterface {

  public function __construct(protected readonly GroupMediaUploadAccess $access) {
    // No op.
  }

  /**
   * Access callback.
   */
  public function access(RouteMatchInterface $route_match, AccountInterface $account): AccessResult {
    $this->access->groupUploadAccess($route_match->getParameter('group'), $account);

    return AccessResult::allowed()
      ->addCacheContexts(['user.group_permissions'])
      ->setCacheMaxAge(0);
  }

}
