<?php

declare(strict_types=1);

namespace Drupal\Tests\group_notify\Unit;

use Drupal\Component\Serialization\Json;
use Drupal\Component\Serialization\Yaml;
use Drupal\Tests\UnitTestCase;

/**
 * Verifies that core_version_requirement and composer.json agree.
 *
 * @group group_notify
 */
class ComposerRequireTest extends UnitTestCase {

  /**
   * Tests the require line from composer.json matches core_version_requirement.
   */
  public function testComposerRequire(): void {
    $module_path = dirname(__FILE__) . '/../../../';
    $parsed_info = Yaml::decode(file_get_contents($module_path . 'group_notify.info.yml'));

    // When running on GitLab CI, there's all sorts of funny business that
    // happens to our composer.json file. So our .gitlab-ci.yml file tries to
    // copy composer.json to composer.json.orig before anything else
    // happens. Therefore, if we see a `composer.json.orig` file in the module
    // directory, compare that instead of whatever is in `composer.json`.
    $composer_file = file_exists($module_path . 'composer.json.orig') ? 'composer.json.orig' : 'composer.json';
    $parsed_composer = Json::decode(file_get_contents($module_path . $composer_file));

    $this->assertEquals($parsed_info['core_version_requirement'], $parsed_composer['require']['drupal/core']);
  }

}
