# Testing Group PURL Module

This document describes how to run tests for the Group PURL module.

## Prerequisites

- Drupal 10.3+ or 11.0+
- PHP 8.1+
- MySQL/MariaDB
- Composer
- PHPUnit (installed via Composer)

## Required Modules

The following modules must be enabled for tests to run:

- `node`
- `path_alias` 
- `group` (3.x)
- `purl`
- `group_purl`

## Running Tests Locally

### Setup

1. Install dependencies:
```bash
composer install
```

2. Set environment variables:
```bash
export SIMPLETEST_BASE_URL="http://localhost:8080"
export SIMPLETEST_DB="mysql://drupal:drupal@localhost:3306/drupal_test"
export BROWSERTEST_OUTPUT_DIRECTORY="/path/to/webroot/sites/default/files/simpletest/browser_output"
```

3. Start a web server (for functional tests):
```bash
php -S localhost:8080 -t web web/.ht.router.php
```

### Running Unit Tests

```bash
vendor/bin/phpunit --configuration web/modules/contrib/group_purl/phpunit.xml --testsuite group_purl-unit
```

### Running Functional Tests

```bash
vendor/bin/phpunit --configuration web/modules/contrib/group_purl/phpunit.xml --testsuite group_purl-functional
```

### Running All Tests

```bash
vendor/bin/phpunit --configuration web/modules/contrib/group_purl/phpunit.xml
```

## Test Coverage

### Unit Tests

- **GroupPurlProviderTest**: Tests the PURL provider's cache management and modifier data retrieval
- **GroupPrefixMethodTest**: Tests PURL path processing logic for prefix-based routing

### Functional Tests  

- **GroupPurlIntegrationTest**: Tests end-to-end functionality including:
  - Group context URL generation
  - Edit form context maintenance
  - Wrong context redirects 
  - PURL provider integration
  - Non-group content handling
  - Cache invalidation
  - Query parameter handling
  - Complex path structures
  - Multiple nested group contexts
  - Permission handling

## GitLab CI

The module includes a `.gitlab-ci.yml` configuration that runs tests automatically on:

- Multiple PHP versions (8.1, 8.2, 8.3)
- Multiple Drupal versions (10.3, 11.0)
- Code quality checks (PHPCS, PHPStan)

## Debugging Tests

To debug failed tests:

1. Check the browser output directory for screenshots and HTML dumps
2. Enable verbose output:
```bash
vendor/bin/phpunit --configuration web/modules/contrib/group_purl/phpunit.xml --verbose
```

3. Run specific test methods:
```bash
vendor/bin/phpunit --configuration web/modules/contrib/group_purl/phpunit.xml --filter testGroupContextUrlGeneration
```

## Writing New Tests

When adding new functionality:

1. Add unit tests for individual classes/methods in `tests/src/Unit/`
2. Add functional tests for user-facing features in `tests/src/Functional/`
3. Follow Drupal testing conventions and use the `@group group_purl` annotation
4. Update this documentation when adding new test scenarios