<?php

namespace Drupal\group_purl\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\group\Entity\Controller\GroupRelationshipController;
use Drupal\group_purl\Context\GroupPurlContext;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Class GroupPurlContentController.
 */
class GroupPurlContentController extends ControllerBase {

  /**
   * Group Purl Context.
   *
   * @var \Drupal\group_purl\Context\GroupPurlContext
   */
  protected $context;

  /**
   * Group Relationship Controller.
   *
   * @var \Drupal\group\Entity\Controller\GroupRelationshipController
   */
  protected $groupRelationshipController;

  /**
   * GroupPurlContentController constructor.
   *
   * @param \Drupal\group_purl\Context\GroupPurlContext $context
   *   GroupPurlContext service.
   * @param \Drupal\group\Entity\Controller\GroupRelationshipController $controller
   *   GroupRelationshipController instance.
   */
  public function __construct(
    GroupPurlContext $context,
    GroupRelationshipController $controller,
  ) {
    $this->context = $context;
    $this->groupRelationshipController = $controller;
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('group_purl.context_provider'),
      GroupRelationshipController::create($container)
    );
  }

  /**
   * Provides a group content creation form.
   *
   * @param string $plugin_id
   *   The group content enabler to add content with.
   *
   * @return array
   *   A group content creation form.
   */
  public function createForm($plugin_id) {
    $group = $this->context->getGroupFromRoute();
    if (empty($group)) {
      throw new NotFoundHttpException('No group found.');
    }
    return $this->groupRelationshipController->createForm($group, $plugin_id);
  }

  /**
   * Title callback.
   *
   * @param string $plugin_id
   *   The group content enabler to create content with.
   *
   * @return string
   *   The page title.
   */
  public function createFormTitle($plugin_id) {
    $group = $this->context->getGroupFromRoute();
    if (empty($group)) {
      throw new NotFoundHttpException('No group found.');
    }
    return $this->groupRelationshipController->createFormTitle($group, $plugin_id);
  }

}
