<?php

namespace Drupal\group_purl\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Class RouteSubscriber.
 *
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Add a wrapper around entity.node.canonical to redirect group nodes
    // if not in active context.
    if ($route = $collection->get('entity.node.canonical')) {
      $route->setOption('_orig_controller', $route->getDefault('_controller'));
      $route->setDefault('_controller', '\Drupal\group_purl\Controller\NodeGroupViewController:view');
    }

    // Add a wrapper around entity.group.canonical to redirect groups
    // if not in correct context.
    if ($route = $collection->get('entity.group.canonical')) {
      $route->setOption('_orig_controller', $route->getDefault('_controller'));
      $route->setDefault('_controller', '\Drupal\group_purl\Controller\GroupViewController:view');
    }
  }

}
