<?php

declare(strict_types=1);

namespace Drupal\group_sitemap\Drush\Commands;

use Drupal\Core\State\StateInterface;
use Drupal\group_sitemap\SiteMap;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;

/**
 * Provides document fetching commands.
 */
final class GroupSitemapCommands extends DrushCommands {

  use AutowireTrait;

  /**
   * Constructs a new GroupSitemapCommands object.
   */
  public function __construct(
    private readonly StateInterface $state,
  ) {
    parent::__construct();
  }

  /**
   * Recreate all sitemaps.
   */
  #[CLI\Command(name: 'group_sitemap:recreate', aliases: ['gsmr'])]
  #[CLI\Usage(name: 'drush gsmr', description: 'Recreate all sitemaps for all groups or process existing queue if there are items pending.')]
  public function recreateSitemaps(array $options = []): void {
    // If anything was enqueued - clear.
    $this->state->delete(SiteMap::RECREATE_STATE_KEY);

    // Set and process batch.
    $batch = SiteMap::getBatchArray();
    \batch_set($batch);
    \drush_backend_batch_process();
  }

}
