<?php

declare(strict_types=1);

namespace Drupal\group_sitemap\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the group_sitemap config entity type.
 *
 * @ConfigEntityType(
 *   id = "group_sitemap",
 *   label = @Translation("Group sitemap"),
 *   config_prefix = "group_sitemap",
 *   admin_permission = "administer group",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "status",
 *     "relationshipTypes",
 *     "changeFreq"
 *   }
 * )
 */
final class GroupSitemap extends ConfigEntityBase {

  /**
   * The group type ID.
   */
  protected string $id = '';

  /**
   * Group membership roles to assign upon registration.
   *
   * @var string[]
   */
  protected array $relationshipTypes = [];

  /**
   * Group page change frequency.
   */
  protected string $changeFreq = 'daily';

  /**
   * Get relationship types.
   */
  public function getRelationshipData(): array {
    return $this->get('relationshipTypes');
  }

  /**
   * Get change frequency.
   */
  public function homeChangeFreq(): string {
    return $this->get('changeFreq');
  }

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies(): self {
    parent::calculateDependencies();

    $group_type = $this->entityTypeManager()
      ->getStorage('group_type')
      ->load($this->id);
    if ($group_type !== NULL) {
      $this->addDependency('config', $group_type->getConfigDependencyName());
    }

    return $this;
  }

}
