<?php

declare(strict_types=1);

namespace Drupal\group_sitemap\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\group_sitemap\SiteMap;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Executes interface translation queue tasks.
 */
#[QueueWorker(
  id: SiteMap::QUEUE_NAME,
  title: new TranslatableMarkup('Create / update site map items'),
  cron: ['time' => 15]
)]
final class SitemapProcessor extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new SitemapProcessor object.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    array $plugin_definition,
    private readonly SiteMap $siteMap,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('group_sitemap.sitemap')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    $this->siteMap->processItem($data);
  }

}
