This module integrates the GSAP (GreenSock Animation Platform) JavaScript library with Drupal, providing flexible, on-demand loading of GSAP plugins and tools for site builders and developers.

Features:
- **On-demand GSAP plugin loading:** Select which GSAP plugins to include globally via the admin UI, or load them only when needed for specific features. You can also add your own custom CDN or local JS libraries for advanced use cases.
- **GSAP Entity:** Create GSAP entities to target elements on any page and apply simple `to`, `from`, or `scrollTrigger` animations using configuration, without writing custom PHP. This allows site builders to animate elements by simply specifying selectors and animation parameters.
- **Developer-friendly:** Designed to speed up integration for developers using their own custom JS to incorporate GSAP animations. All selected plugins are available globally, so you can use GSAP and its plugins in your own scripts without additional setup.
- **Custom CDN or Local Libraries:** Use the included `composer.libraries.json` to load GSAP libraries locally, or specify your own CDN URLs for custom or premium plugins. This is useful for enterprise environments or when you need to use a self-hosted version of GSAP.

Usage:
1. **Enable the module** and configure which GSAP plugins to load via the admin form at `/admin/config/gsap`.
2. **Create GSAP entities** to define animation targets and behaviors. For example, you can create an entity that targets `.hero-title` and animates it with a fade-in effect using GSAP's `to` method.
3. **Create your own JS library** and declare dependencies in your library definition, for example:

```yaml
my_custom_animations:
  js:
    js/my-custom-animations.js: {}
  dependencies:
    - gsap/gsap
    - gsap/scrolltrigger
```

Then, in your custom JS file, you can use GSAP and any enabled plugins:

```js
// Example: Animate all elements with class .fade-in using GSAP's to method
((gsap) => {
  gsap.to('.fade-in', { opacity: 1, duration: 1 });
})(gsap);

// Example: Animate .section when it enters the viewport using ScrollTrigger
((gsap, ScrollTrigger) => {
  gsap.registerPlugin(ScrollTrigger);
  gsap.to('.section', {
    scrollTrigger: '.section',
    y: 0,
    opacity: 1,
    duration: 1
  });
})(gsap, ScrollTrigger);
```

**Advanced:**
- To use local libraries instead of CDN, update `composer.libraries.json` and configure your environment to use local assets.
- You can add custom libraries via the admin UI for additional JS plugins or premium GSAP plugins.

For more information on GSAP, visit https://greensock.com/gsap/.

TODO: Add more usage examples and advanced configuration tips.
