# GSAP JS

## Introduction

This Drupal module integrates the **GSAP (GreenSock Animation Platform)**
library into your site. GSAP is a high-performance JavaScript animation
framework used by professionals to create complex, fluid animations.

- Website: https://gsap.com/
- GitHub: https://github.com/greensock/GSAP
- License: GreenSock Standard "No Charge" License (not GPL-compatible)

**Note:** This module does not bundle GSAP due to GPL compatibility rules.
You must install GSAP yourself (via CDN or `libraries/gsap`). See below.

---

## Features

- Attaches GSAP globally or conditionally (via optional UI submodule)
- Supports local library (`libraries/gsap`) or CDN loading
- Supports all official GSAP plugins
- Compatible with Drupal 9.5, 10, and 11
- Minimal footprint in the base module; configuration lives in `gsapjs_ui`

---

## Requirements

- Drupal core 9.5 or newer
- GSAP library installed locally or loaded from CDN
- No external build tools required

---

## Installation

### 1. Install the module
Download this module into `/modules/contrib/gsapjs` and enable it:

   ```bash
      drush en gsapjs
   ```

### 2. Install GSAP
You have two options:

#### A) Local copy
Download GSAP from https://gsap.com/

Place it in your site's libraries/gsap directory, so that
libraries/gsap/dist/gsap.min.js exists.

#### B) CDN
Use the gsapjs_ui submodule to configure a CDN source for GSAP.

---

## Usage
Once GSAP is loaded, you can use it in your theme or modules.

Example (place in your theme’s JS):

```javascript
// Simple fade in for all <h1> elements
gsap.from("h1", { duration: 1, opacity: 0, y: -50 });

// Timeline example
const tl = gsap.timeline();
tl.to(".box", { x: 200, duration: 1 })
  .to(".box", { rotation: 360, duration: 1 })
  .to(".box", { opacity: 0, duration: 0.5 });
```

* To use GSAP plugins, attach them via Drupal's #attached['library'][]
using the keys defined in gsapjs.libraries.yml.

---

### License and Legal Notice
Module license: GPL-2.0-or-later

GSAP license: GreenSock Standard "No Charge" License
(see https://gsap.com/community/standard-license/)

GSAP is not GPL-compatible. This module does not ship GSAP files.
You must install GSAP separately. See installation instructions above.

By using GSAP, you agree to its license terms in addition to GPL.

---
### DEMO
https://gsap.com/demos/

---

## 👤 MODULE MAINTAINERS

The following person is actively maintaining this module:

- **Mahyar Sabeti** ([mahyarsbt](https://www.drupal.org/u/mahyarsbt))
