<?php

namespace Drupal\gsislogin\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Implements the GSIS login form.
 */
class GsisLoginForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'gsislogin_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['gsis'] = [
      '#type' => 'inline_template',
      '#template' => '<a class="btn btn-block btn-lg btn-gsis" href="{{ url }}"><i class="socicon-gsis"></i>{{ "Login via Taxisnet"|t }}}</a>',
      '#context' => [
        'url' => Url::fromRoute('gsislogin.login'),
      ],
    ];
    $form['#attached']['library'][] = 'gsislogin/gsislogin';
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    // Nothing to validate here.
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Never comes here.
    return TRUE;
  }

}
