import advancedLinkIcon  from './components/advanced-link-icon';
import { RichTextToolbarButton  } from '@wordpress/block-editor';
import { applyFormat, toggleFormat, removeFormat, useAnchor } from '@wordpress/rich-text';
import { useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import { Popover, TextControl, Button, SelectControl, CheckboxControl ,
	__experimentalHStack as HStack,
	__experimentalVStack as VStack
} from '@wordpress/components';
import { SVG, Path } from '@wordpress/primitives';





const AdvancedLink = {
  title: 'Infobulle',
  tagName: 'a',
  className: 'custom-a',
  attributes: {
    //caption: 'data-caption',
    href: 'href',
    class: 'class',
    target: 'target',
    rel: 'rel'
  },  
  edit: Edit,
};



function Edit( props ) {
    //const anchorRef = useAnchor( { editableContentElement: contentRef.current, value } );
    var isActive = props.isActive;
    var value = props.value;
    var onChange = props.onChange;
    var attributes = props.attributes;
    var contentRef = props.contentRef;
    var activeAttributes = props.activeAttributes;


    const [ isPopoverVisible, setIsPopoverVisible ] = useState( false );
    const togglePopover = () => {
      setIsPopoverVisible( ( state ) => ! state );
    };


    const highlighterIcon = advancedLinkIcon
    
    return (
      <>
        <RichTextToolbarButton
            icon={ highlighterIcon }
            title={ __( 'Advanced link', 'gutenberg-advanced-link' ) }
            isActive={ isActive }
            onClick={ () => { 
              /*
                if ( isActive ) {
                //on supprime le lien si on clique à nouveau sur Advanced link
                onChange(
                    toggleFormat( value, {
                        type: 'gutenberg-advanced-link/advanced-link',
                    }
                    )
                    
                ); 
              }
              else {
                togglePopover();
              }*/

              togglePopover();

            } }
        />
        { isPopoverVisible &&  
        <InlineAdvancedLinkUI
					isActive={ isActive }
					activeAttributes={ activeAttributes }
					value={ value }
					onChange={ onChange }
					contentRef={ contentRef }
					onClose={ togglePopover }
				/>        
        }
        
      </>
    );
};


function InlineAdvancedLinkUI( {
  isActive,
	activeAttributes,
	value,
	onChange,
  onClose,
	contentRef,
} ) {
  
  const popoverAnchor = useAnchor( {
    editableContentElement: contentRef.current,
    settings: AdvancedLink
  } );


	const [ hrefAttr, setHrefAttr ] = useState( activeAttributes.href );
	const [ classAttr, setClassAttr ] = useState( activeAttributes.class );
	const [ targetAttr, setTargetAttr ] = useState( activeAttributes.target || '_self' );
	const [ relAttr, setRelAttr ] = useState( activeAttributes.rel );


  return (
    <>
    <Popover
        anchor={ popoverAnchor }
        headerTitle="Class CSS"
       // position='bottom center'
        //placement='bottom'
        //offset={ 8 }
        className= "block-editor-href-popover"
			  onClose={ onClose }
        >
      <VStack
				as="form"
				spacing={ 4 }
				className="block-editor-format-toolbar__language-container-content"
				onSubmit={ ( event ) => {
					event.preventDefault();
          
          if(hrefAttr) {
            onChange(
              applyFormat( value, {
                type: 'gutenberg-advanced-link/advanced-link',
                attributes: {
                  href: hrefAttr || '',
                  class: classAttr || '',
                  target: targetAttr || '',
                  rel: relAttr || '',
                }
              } )
            );
          }
          else {
            setHrefAttr( '' );
            setClassAttr( '' );
            setTargetAttr( '' );
            setRelAttr( '' );
            const newValue = removeFormat( value, 'gutenberg-advanced-link/advanced-link');            
            onChange( newValue );
          }
          onClose();

				} }
			>

          <div class="block-editor-link-control">
          <TextControl
          label="Url"
          className="block-editor-link-control__field block-editor-link-control__text-content"
          value = { hrefAttr }
          onChange={ 
            (newHref) => setHrefAttr( newHref || '' )
          }
          
          />

          <TextControl 
          label="Class"
          className="block-editor-link-control__field block-editor-link-control__text-content"
          value = { classAttr }
          onChange={ 
            (newClass) => setClassAttr( newClass || '' )
          }
          
          />

        <SelectControl
          className="block-editor-link-control__field block-editor-link-control__text-content"
          label="Target"
          value = { targetAttr }
          options={ [
              { label: '_none', value: '_self' },
              { label: '_blank', value: '_blank' },
              { label: '_self', value: '_self' },
              { label: '_parent', value: '_top' },
          ] }
          onChange={ 
            (newTarget) => setTargetAttr( newTarget || '' )
          }
        />
        <TextControl 
          label="Target - framename"
          className="block-editor-link-control__field block-editor-link-control__text-content"
          value = { targetAttr }
          onChange={ 
            (newTarget) => setTargetAttr( newTarget || '' )
            }
          
          />

          <CheckboxControl
            label="nofollow"
            checked={ relAttr == 'nofollow' ? true : false }
            className="block-editor-link-control__field "
            onChange={ 
              (newNofollow) => setRelAttr( newNofollow ? 'nofollow' : '' )   
              }
          />              
          </div>
          <div>
            <Button
              __next40pxDefaultSize
              variant="primary"
              type="submit"
              text={ __( 'Apply' ) }
            />

            
          </div>
        </VStack>
        </Popover>
    </>
  )

}

export default AdvancedLink;