# Gutenberg Block Report

The Gutenberg Block Report module provides an administrative report that scans content and summarizes which Gutenberg blocks are used across your site. It lists each block, the number of occurrences, and links to the nodes where the block appears.

The main report is available at Admin > Reports > Gutenberg block report, and shows:
- Block Name (human-friendly label and machine name)
- Total count of occurrences across all content
- A sample of nodes using the block and a link to view more nodes per block

## Table of contents

- Requirements
- Installation
- Configuration
- Usage
- Maintainers

## Requirements

- Core modules
  - node

## Installation

Install as you would normally install a custom or contributed Drupal module. For further information, see:
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

This module has no configuration settings.

Permissions:
- Access to the report requires the "administer nodes" permission.

Menu and routes:
- Admin menu link: Admin > Reports > Gutenberg block report
- Main report route: `/admin/reports/gutenberg-block-report`
- Per-block nodes route: `/admin/reports/gutenberg-block-report/nodes` (linked from the main report)

## Usage

1. Navigate to Admin > Reports > Gutenberg block report.
2. Review the list of Gutenberg blocks detected in node content.
3. Click the per-block links to view the nodes where a given block appears along with occurrence counts per node.

## Maintainers

- Neslee Canil Pinto - [Neslee Canil Pinto](https://www.drupal.org/u/neslee-canil-pinto)
