<?php

namespace Drupal\h5p_challenge_rest\Normalizer;

use Drupal\h5p_challenge\FetchClass\H5PChallenge;
use Drupal\serialization\Normalizer\NormalizerBase;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * StdClass normalizer.
 */
class NormalizerH5PChallenge extends NormalizerBase {

  /**
   * {@inheritdoc}
   */
  public function normalize($data, $format = NULL, array $context = []): array|bool|string|int|float|null|\ArrayObject {
    $attributes = [];

    foreach ($data as $name => $property) {
      if ($name === 'data') {
        $property = $property ? unserialize($property) : [];
      }

      if ($name === 'started' || $name === 'finished') {
        // TODO See if we need to set the timezone as the DateTimeNormalizer
        // does
        $property = DrupalDateTime::createFromTimestamp($property)
          ->format(\DateTime::RFC3339);
      }

      if ($name === 'results_sent') {
        $property = (bool) $property;
      }

      if (in_array($name, ['content_id', 'user_id',])) {
        $property = (int) $property;
      }

      $attributes[$name] = $property;
    }

    return $attributes;
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedTypes(?string $format) : array {
    return [
      H5PChallenge::class => TRUE,
    ];
  }

}
