<?php

namespace Drupal\hal_publications\Entity;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access control handler for HAL Author entities.
 */
class HalAuthorAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\hal_publications\Entity\HalAuthorInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished hal authors');
        }
        return AccessResult::allowedIfHasPermission($account, 'view hal authors');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'administer hal authors');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'administer hal authors');
    }
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'administer hal authors');
  }

}
