# HAL Publications

## Introduction

The HAL Publications module integrates with the HAL (Hyper Articles en Ligne) API to fetch and display academic publications on your Drupal site. It provides a configurable block that displays publications with support for multiple citation formats, filtering, and pagination.

## Features

- Multiple citation formats: APA 7th edition, MLA 9th edition, Vancouver, and Harvard
- Configurable portals and collections
- Filter publications by author, year, and text search
- Client-side pagination
- PDF download links with embargo indicators
- Publisher links
- Author management through content entities

## Requirements

- Drupal 10.2+ or Drupal 11
- PHP 8.1+
- [Chosen](https://www.drupal.org/project/chosen) module

## Installation

Install as you would normally install a contributed Drupal module. See [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules) for further information.

## Configuration

### Module Settings

Navigate to **Configuration → HAL Publications** (`/admin/config/hal`) to configure:

- **Portals**: Add HAL portals (format: `id|Label`, e.g., `tel|TEL Portal`)
- **Collections**: Add HAL collections (format: `id|Label`, e.g., `FRANCE-GRILLES|France Grilles`)
- **API Timeout**: Request timeout in seconds (default: 30)
- **Disable SSL Verification**: Development only setting (never use in production)

### Block Configuration

1. Go to **Structure → Block layout**
2. Add the "HAL Publications" block to a region
3. Configure the block:
   - **Citation Format**: Select APA, MLA, Vancouver, or Harvard (required)
   - **Sort**: Select sorting option (Date, Author, or Title)
   - **Portal**: Select a configured portal (optional)
   - **Collection**: Select a configured collection (optional)
   - **Author Filter**: Filter by specific HAL author ID (optional)
   - **Year Filter**: Filter by publication year (optional)
   - **Text Search**: Search in publication titles and content (optional)
   - **Pagination**: Enable/disable pagination
   - **Items Per Page**: Number of publications per page (default: 20)
   - **Show Filters**: Display filter form to users

### Author Management

Create HAL Author entities to manage authors:

1. Go to **Content → HAL Authors** (`/admin/content/hal-author`)
2. Click "Add HAL Author"
3. Enter:
   - **Title**: Author display name
   - **HAL ID**: HAL identifier (required)

## Usage

After configuration, the block will automatically fetch and display publications from the HAL API based on your settings. Users can filter publications using the filter form if enabled in block configuration.

Citation formats are automatically applied based on your selection. All formats are compliant with their respective style guides:

- **APA 7th Edition**: Author format "Last, Initial." with ampersand before last author
- **MLA 9th Edition**: Author format "Last, First" for first author, "First Last" for others
- **Vancouver**: Author format "LastName Initial" with "et al." after 6 authors
- **Harvard**: Standard academic format

## Troubleshooting

### Publications Not Displaying

- Verify HAL API connectivity
- Check portal and collection IDs are correct
- Review Drupal logs for API errors at `/admin/reports/dblog`

### SSL Certificate Errors

If you encounter SSL errors in development, enable "Disable SSL verification" in module settings. **Warning**: Never use this in production.

### Citation Format Issues

- Verify the selected format in block configuration
- Ensure all required API fields are available from HAL

## License

GPL-2.0-or-later
