<?php

namespace Drupal\hal_publications\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form handler for HAL Author entities.
 */
class HalAuthorForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $hal_id = trim((string) $this->entity->get('hal_id')->value);

    // Auto-populate title with HAL ID if empty.
    if ($this->entity->isNew() && empty($this->entity->get('title')->value) && $hal_id !== '') {
      $form['title']['#default_value'] = $hal_id;
    }

    // Add description to title field.
    if (isset($form['title']['widget'][0]['value'])) {
      $form['title']['widget'][0]['value']['#description'] = $this->t('Enter author name (e.g., "Last, First" or full name). This is for display only - author names in citations come from HAL API.');
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;
    $status = $entity->save();

    $message = $status == SAVED_NEW
      ? $this->t('Created HAL author %name.', ['%name' => $entity->label()])
      : $this->t('Updated HAL author %name.', ['%name' => $entity->label()]);

    $this->messenger()->addStatus($message);

    $form_state->setRedirect('entity.hal_author.collection');

    return $status;
  }

}
