# Heading Formatter

## Introduction

This Drupal module provides a straightforward field formatter that allows site builders to display plain text fields as headings with custom CSS classes. It is designed to enhance flexibility and consistency when styling headings in your Drupal website.

## Features

- Format plain text fields as headings (e.g., H1, H2, H3, etc.).
- Add custom CSS classes to style headings as needed.
- Simple configuration options for easy setup.

## Installation

1. Download the module:
   - Using Composer:
     ```bash
     composer require drupal/heading_formatterng
     ```
   - Or manually download the module and place it in the `modules/custom` directory.
2. Enable the module:
   ```bash
   drush en heading_formatterng
   ```
   Or enable it via the **Extend** page in the Drupal admin interface.

## Usage

1. Navigate to the **Manage Display** page of the desired content type or entity bundle.
2. Locate the plain text field you want to format.
3. Select the **Heading Formatter** from the field formatter dropdown menu.
4. Configure the formatter settings:
   - Choose the heading level (e.g., H1, H2, H3, etc.).
   - Specify any custom CSS classes to apply.
5. Save the changes.

## Requirements

- Drupal 10 or later.

## Configuration

No additional configuration is required beyond setting up the field formatter on the desired content type or entity bundle.

## Support

If you encounter any issues or have questions about this module, please create an issue in the module's issue queue on Drupal.org.

## License

This module is open-source and available under the [GPL-2.0-or-later](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html) license.
