# Drupal 11 headless API Installation Profile

Drupal 11 Headless API is an installation profile designed to jump‑start fully decoupled and API-focused Drupal projects.

It ships with a ready‑to‑use headless architecture, featuring OpenAPI and Swagger UI, along with some utilities for Drupal core.

---

## 📦 Requirements

- PHP 8.4+
- Composer 2.x
- Drupal ^11.3
- MYSQL/MariaDB database

---

## 🛠️ Installation (with DDEV)

1) Create a new fresh Drupal 11 instance with DDEV:
    ```shell
    mkdir my-drupal-headless-api && cd my-drupal-headless-api && \
    ddev config --project-type=drupal --docroot=web --php-version=8.4 --database=mariadb:11.8 && \ 
    ddev start
    ddev composer create-project drupal/recommended-project:^11.3 && \
    ddev composer config minimum-stability RC
    ```

2) Include this installation profile:
    ```shell
    ddev composer require deviktta/headless_api_distribution:^1.0
    ```

3) Install Drupal using this installation profile:
    ```shell
    ddev drush site:install headless_api_distribution \
      --site-name="My Drupal headless API" \
      --site-mail="admin@example.org" \
      --account-name=admin \
      --account-pass=admin \
      --account-mail=admin@example.org \
      --yes
    ```
