# Drupal 11 headless API - Installation Profile

Drupal 11 Headless API is an installation profile designed to jump‑start fully decoupled and API-focused Drupal projects.

It ships with a ready‑to‑use headless architecture, featuring OpenAPI and Swagger UI, along with some utilities for Drupal core.

---

## Usage (with DDEV)

1) Create a new fresh Drupal 11.3 instance with DDEV:
   ```shell
   # Create DDEV project
   mkdir my-headless-api-drupal && cd my-headless-api-drupal
   ddev config --project-type=drupal11 --docroot=web --php-version=8.4
   ddev start 
   
   # Install new a Drupal v11.3
   ddev composer create-project drupal/recommended-project:^11.3
   ddev composer config minimum-stability RC
   ```
   _Minimum stability set to RC is required by [openapi_ui](https://www.drupal.org/project/openapi_ui">drupal/openapi_ui)._

2) Include this installation profile:
   ```shell
   # Add this repository to Composer
   ddev composer config repositories.drupal_distribution_headless_api vcs https://git.drupalcode.org/project/headless_api_distribution.git
   
   # Install this Composer package
   ddev composer require drupal/headless_api_distribution:^1.0
   ```

3) Install Drupal using this installation profile:
   ```shell
   ddev drush site:install headless_api_distribution \
      --site-name="My Drupal headless API" \
      --site-mail="admin@example.org" \
      --account-name=admin \
      --account-pass=admin \
      --account-mail=admin@example.org \
      --yes
   ```

## Maintainers

- [deviktta](https://www.drupal.org/u/deviktta)
