<?php

declare(strict_types=1);

namespace Drupal\hello_login;

use HelloCoop\HelloClient;

/**
 * Provides HelloConfig objects for managing HelloCoop client.
 */
class HelloClientFactory {
  /**
   * Factory class for creating HelloConfig objects.
   *
   * @var \HelloCoop\HelloConfigFactory
   */
  protected $configFactory;

  public function __construct(HelloConfigFactory $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * Creates the HelloCoop client, with the given configuration.
   */
  public function createClient($httpRequestService, $httpResponseService, $pageRenderer): HelloClient {
    $config = $this->configFactory->createConfig();
    return new HelloClient($config, $httpRequestService, $httpResponseService, $pageRenderer);
  }

}
