<?php

namespace Drupal\hello_login\EventSubscriber;

use Drupal\Core\Config\ConfigEvents;
use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\Routing\RouteBuilderInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Rebuilds the route cache after configuration changes.
 */
class CacheClearSubscriber implements EventSubscriberInterface {
  /**
   * The route builder service.
   *
   * @var \Drupal\Core\Routing\RouteBuilderInterface
   */
  protected $routeBuilder;

  /**
   * Constructs the subscriber.
   *
   * @param \Drupal\Core\Routing\RouteBuilderInterface $routeBuilder
   *   The route builder service.
   */
  public function __construct(RouteBuilderInterface $routeBuilder) {
    $this->routeBuilder = $routeBuilder;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    // Subscribe to the config save event.
    $events[ConfigEvents::SAVE][] = ['onConfigSave'];
    return $events;
  }

  /**
   * Rebuilds the route cache when the 'hello_login.settings' config is saved.
   */
  public function onConfigSave(ConfigCrudEvent $event) {
    $config_name = $event->getConfig()->getName();

    // Check if the 'hello_login.settings' configuration was saved.
    if ($config_name == 'hello_login.settings') {
      // Rebuild the route cache.
      $this->routeBuilder->rebuild();
    }
  }

}
