<?php

namespace Drupal\hello_login\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\Config;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Dynamically alters the API route.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The HelloCoop configuration.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected Config $config;

  /**
   * Constructs a Drupal RouteSubscriber.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory service.
   */
  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->config = $configFactory->get('hello_login.settings');
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    $api_route = $this->config->get('api_route') ?? '/api/hellocoop';

    if ($route = $collection->get('hello_login.api_endpoint')) {
      $route->setPath($api_route);
    }
  }

}
