<?php

/**
 * @file
 * Hooks provided by the Hierarchical Select Ajax module.
 */

/**
 * Alters the hierarchical select AJAX element.
 *
 * This hook allows modules to modify the hierarchical select AJAX element,
 * enabling customization such as altering attributes, or child elements.
 *
 * @param array $element
 *   The rendered element representing the hierarchical select AJAX element.
 * @param array $context
 *   An additional variable that is passed by reference.
 */
function hook_hierarchical_select_ajax_element_alter(&$element, &$context) {
  $element['target_id']['#title'] = t('Location');
}

/**
 * Alters hierarchical select AJAX settings.
 *
 * Allows modules to modify hierarchical select settings,
 * such as labels or depth.
 *
 * @param array $settings
 *   The hierarchical select AJAX settings array (e.g., 'hierarchy_depth',
 *   'label_level' using newline-separated values).
 * @param array $context
 *   An additional variable that is passed by reference.
 */
function hook_hierarchical_select_ajax_settings_alter(&$settings, &$context) {
  $settings['label_level'] = "Oblast\nHromada";
  $settings['hierarchy_depth'] = 4;
}
