<?php

namespace Drupal\hierarchical_select_ajax\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\shs\Plugin\Field\FieldFormatter\EntityReferenceShsFormatter;

/**
 * Plugin implementation of the 'hierarchical_select_ajax_shs' formatter.
 *
 * @FieldFormatter(
 *   id = "hierarchical_select_ajax_shs",
 *   label = @Translation("Hierarchical select ajax - SHS"),
 *   field_types = {
 *     "entity_reference"
 *   }
 * )
 */
class HierarchicalSelectAjaxShsFormatter extends EntityReferenceShsFormatter {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      'label_level' => '',
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $elements = parent::settingsForm($form, $form_state);

    // Enforce default SHS settings.
    $elements['display_plain_text']['#access'] = FALSE;
    $elements['display_plain_text']['#value'] = TRUE;
    $elements['display_plain_text_separator']['#access'] = FALSE;
    $elements['display_plain_text_separator']['#value'] = '>';

    // Configuration for admin-level labels.
    $elements['label_level'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Label per level'),
      '#default_value' => $this->getSetting('label_level'),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    // Get default rendered elements and field settings.
    $elements = parent::viewElements($items, $langcode);
    $settings = $this->getSettings();

    // Context info for the element to be altered.
    $hsa_info = [
      'field_name' => $this->fieldDefinition->getName(),
      'entity_type' => $this->fieldDefinition->getTargetEntityTypeId(),
      'bundle' => $this->fieldDefinition->getTargetBundle(),
      'entity' => $items->getEntity(),
    ];

    // Allow other modules to alter formatter.
    \Drupal::moduleHandler()->alter('hierarchical_select_ajax_settings', $settings, $hsa_info);

    // Convert newline-separated labels to an array.
    $labels = $settings['label_level'] ? array_map('trim', explode(PHP_EOL, $settings['label_level'])) : NULL;

    // Apply theme and labels to each rendered item.
    foreach ($items as $delta => $item) {
      $elements[$delta]['#theme'] = 'hsa_shs';
      $elements[$delta]['#labels'] = $labels;
    }

    return $elements;
  }

}
