<?php

namespace Drupal\Tests\highlight\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests that the highlight.js file is properly attached to pages.
 */
class HighlightEnabledTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['highlight'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setup(): void {
    parent::setup();

    $config = $this->config('system.performance');
    $config->set('css.preprocess', 0);
    $config->set('js.preprocess', 0);
    $config->save();
  }

  /**
   * Tests that highlight.js library is attached to pages.
   */
  public function testHighlightJsAttached() {
    // Create a user with permission to view content.
    $account = $this->drupalCreateUser(['access content']);
    $this->drupalLogin($account);

    // Visit a page to trigger page attachments.
    $this->drupalGet('<front>');

    // Check that the highlight library was attached to the page.
    // This tests that our hook_page_attachments() function is properly
    // attaching the libraries.
    $this->assertSession()->responseContains('highlight/js/highlight.js');

    // Also check for the jQuery highlight library.
    $this->assertSession()->responseContains('highlight/js/jquery.highlight.js');
  }

}
