<?php

namespace Drupal\Tests\highlightjs_input_filter\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests access to highlightjs_input_filter's admin page.
 */
#[Group('highlightjs_input_filter')]
class HighlightjsInputFilterAdminAccessTest extends BrowserTestBase {

  /**
   * Modules to enable for this test.
   *
   * @var string[]
   */
  protected static $modules = ['highlightjs_input_filter'];

  /**
   * Use the standard test theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * Test that a normal user cannot access the admin page.
   */
  public function testNormalUserCannotAccessAdminPage() {
    // Create a normal user with no admin permissions.
    $user = $this->drupalCreateUser([]);

    // Log them in.
    $this->drupalLogin($user);

    // Try to access the admin page.
    $this->drupalGet('/admin/config/content/highlightjs_input_filter');

    // Assert access denied (403).
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Test that a user with the right permission can access the page.
   */
  public function testAdminUserCanAccessAdminPage() {
    // Create an admin user with the right permission(s).
    $admin_user = $this->drupalCreateUser(['administer highlightjs_input_filter settings']);
    $this->drupalLogin($admin_user);

    $this->assertTrue(\Drupal::moduleHandler()->moduleExists('highlightjs_input_filter'));

    // Access the admin page.
    $this->drupalGet('/admin/config/content/highlightjs_input_filter');

    // Assert success (200).
    $this->assertSession()->statusCodeEquals(200);
  }

}
