<?php

namespace Drupal\Tests\highlightjs_input_filter\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests saving settings via the module admin form.
 */
#[Group('highlightjs_input_filter')]
class HighlightjsInputFilterSettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['highlightjs_input_filter'];

  /**
   * Use the standard test theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  public function testSettingsFormSavesConfiguration(): void {
    $admin = $this->drupalCreateUser(['administer highlightjs_input_filter settings']);
    $this->drupalLogin($admin);

    $this->drupalGet('/admin/config/content/highlightjs_input_filter');
    $this->assertSession()->statusCodeEquals(200);

    $edit = [
      'enable_copy_button' => TRUE,
      // Choose a canonical path value from the provided options list.
      'theme' => 'base16/3024',
    ];
    $this->submitForm($edit, 'Save configuration');

    $config = \Drupal::config('highlightjs_input_filter.settings');
    $this->assertTrue((bool) $config->get('enable_copy_button'));
    $this->assertSame('base16/3024', (string) $config->get('theme'));
  }

}
