<?php

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter the homebox view build array.
 *
 * @param array &$build
 *   A renderable array representing the homebox entity.
 * @param \Drupal\Core\Entity\EntityInterface $entity
 *   The homebox entity.
 * @param \Drupal\Core\Entity\Display\EntityViewDisplayInterface $display
 *   The entity view display.
 * @param string $view_mode
 *   The view mode.
 */
function hook_homebox_view_builder_build_alter(array &$build, \Drupal\Core\Entity\EntityInterface $entity, \Drupal\Core\Entity\Display\EntityViewDisplayInterface $display, $view_mode) {
  // Example: Add a custom element to the build array.
  $build['custom_element'] = [
    '#markup' => '<div>Custom content added by mymodule.</div>',
    '#weight' => 100,
  ];
}

/**
 * @} End of "addtogroup hooks".
 */
