## INTRODUCTION

The Honeycronpot module is a custom solution for dynamically managing Honeypot field configurations in Drupal. This module automatically updates the element_name for Honeypot protection via Cron jobs, ensuring that bots cannot easily bypass form protection by rotating the name of the hidden honeypot field. This helps improve security and anti-spam measures on your site.

The primary use case for this module is:

- Dynamically rotating Honeypot field names to improve bot detection.
- Automating the configuration of Honeypot protection on forms.
- Running the field name rotation via Cron to ensure optimal security.

Honeycronpot supports two modes of operation:
1. Cache mode – The Honeypot element name is generated dynamically and cached for a configurable duration (default 86400 seconds).
2. Cron mode – The Honeypot element name is updated automatically on each Cron run.

## REQUIREMENTS

- Drupal 10 or higher.
- Honeypot module installed and enabled.
- Cron jobs configured to run the module's tasks.

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

1. Download the module using Composer:
   ```bash
   composer require drupal/honeycronpot
   ```

2. Install the module either via Drush or through the Drupal admin interface:
- Using Drush:
   ```bash
   drush en honeycronpot
   ```
- Using the Drupal admin interface:
   - Navigate to Extend (admin/modules).
   - Find "Honeycronpot" in the list and enable it.

3. Ensure that Cron is configured correctly on your site, as this module requires Cron to function properly.


## CONFIGURATION

### After installing the Honeycronpot module

1. Navigate to Configuration > Honeypot Settings.
2. The module will automatically generate a dynamic element_name for Honeypot fields.
3. You can choose the mode of operation:
   - Cache – Uses a cached element name with a configurable TTL.
   - Cron – Updates the element name automatically during Cron runs.
4. Optionally, customize the prefixes and base names used to generate dynamic element names.
5. Ensure Cron is running regularly to maintain up-to-date Honeypot protection.

### Form integration:
- The module adds a radio button to the Honeypot settings form for selecting the element name mode.
- When Cache mode is selected, a TTL (cache duration) field appears, allowing administrators to configure how long the element name remains cached.
- The TTL field is hidden automatically when Cron mode is selected.

## MAINTAINERS

Current maintainers for Drupal 10:

- Valentin Golemanski (valegole) - https://www.drupal.org/u/valegole

