<?php

namespace Drupal\honeycronpot\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\honeycronpot\Service\HoneycronpotElementNameGenerator;

/**
 * Handles honeycronpot cron tasks.
 */
class HoneycronpotCron {

  /**
   * Constructs a HoneycronpotCron object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory service.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager service.
   * @param \Drupal\honeycronpot\Service\HoneycronpotElementNameGenerator $elementNameGenerator
   *   The element name generator service.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
    protected EntityTypeManagerInterface $entityTypeManager,
    protected readonly HoneycronpotElementNameGenerator $elementNameGenerator,
  ) {
  }

  /**
   * Executes the cron tasks.
   */
  public function onCron(): void {
    $mode = $this->configFactory->get('honeypot.settings')->get('element_name_mode') ?? 'cache';
    if ($mode !== 'cron') {
      return;
    }

    $element_name = $this->elementNameGenerator->generate();

    $this->configFactory->getEditable('honeypot.settings')
      ->set('element_name', $element_name)
      ->save();
  }

}
