# Hook Post Action

## Contents of this File

* Introduction
* Available Hooks
* Installation
* Usage
* Example Module
* Requirements
* Maintainers

## Introduction

You don't need this module unless you're either a developer or another module
you're using depends on it.

Currently, Drupal core does not offer any hook to perform actions after a
node/entity is inserted/updated/deleted in the database. This module introduces
several new Drupal hooks to overcome this limitation.

### Available Hooks

The module provides the following hooks:

- `hook_entity_postsave`
- `hook_entity_postinsert`
- `hook_entity_postupdate`
- `hook_entity_postdelete`
- `hook_node_postsave`
- `hook_node_postinsert`
- `hook_node_postupdate`
- `hook_node_postdelete`

## Installation

Install and enable the module as usual using the following steps:

1. Download the module and extract the files to your Drupal modules directory.
2. Enable the module through the Drupal administration interface.

## Usage

Please refer to the `hook_post_action.api.php` file for detailed usage
instructions.

### Example Module

To quickly see the module in action, you can enable the bundled module
`hook_post_action_example`. Follow these steps:

1. Enable the `hook_post_action_example` module.
2. Add, delete, or update some content on your Drupal site.
3. Visit the logs at `admin/reports/dblog` to see the module's actions logged.

## Requirements

- Drupal 8.x or later

## Maintainers

- Sina Salek - [Website](http://sina.salek.ws)
- Matt Oliveira - [Lullabot](https://www.lullabot.com/about/matt-oliveira)
